setDefaultTab("Healing")
-- =========================
-- STORAGE
-- =========================
local panelName = "smarthealer"

if not storage[panelName] then
  storage[panelName] = {
    healSpell = "",
    healthItemId = 0,
    manaItemId = 0,
    hpPercent = 95,
    mpPercent = 95,
    spellDelay = 1000 -- em ms (default = 1s)
  }
end

local config = storage[panelName]

-- =========================
-- POTIONS OBLIVIAT
-- =========================
local OBLIVIAT_POTIONS = {
  [36733] = true,
  [36729] = true,
  [36732] = true,
  [36740] = true,
  [36736] = true,
  [36739] = true
}

local function useHealingItem(item)
  if not item then return end
  if OBLIVIAT_POTIONS[item:getId()] then
    g_game.use(item)
  else
    g_game.useWith(item, player)
  end
end

-- =========================
-- BOTÃO SETUP
-- =========================

local ui = setupUI([[
Panel
  height: 19

  Button
    id: setup
    anchors.left: parent.left
    anchors.right: parent.right
    height: 17
    text: Setup Heal
]])
ui:setId(panelName)

-- =========================
-- JANELA SETUP
-- =========================
local rootWidget = g_ui.getRootWidget()
local healerWindow

local rootWidget = g_ui.getRootWidget()
local healerWindow

if rootWidget then
  healerWindow = UI.createWindow('SmartHealerWindow', rootWidget)
    -- sincroniza valores iniciais
    config.hpPercent = healerWindow.hpScroll:getValue()
    config.mpPercent = healerWindow.mpScroll:getValue()

      healerWindow:hide()

    healerWindow.closeButton.onClick = function()
        healerWindow:hide()
    end

    healerWindow.hpText:setText("HP % < " .. config.hpPercent)
    healerWindow.mpText:setText("MP % < " .. config.mpPercent)

    -- HP %
    healerWindow.hpScroll.onValueChange = function(_, value)
    config.hpPercent = value
    healerWindow.hpText:setText("HP % < " .. value)
    end

    -- MP %
    healerWindow.mpScroll.onValueChange = function(_, value)
    config.mpPercent = value
    healerWindow.mpText:setText("MP % < " .. value)
    end

    -- Spell
    healerWindow.spellText.onTextChange = function(widget, text)
    config.healSpell = text
    end
    healerWindow.spellText:setText(config.healSpell)

    -- Spell Delay (em ms direto)
    config.spellDelay = healerWindow.spellDelayScroll:getValue()

    healerWindow.spellDelayText:setText("Spell Delay: " .. config.spellDelay .. " ms")

    healerWindow.spellDelayScroll.onValueChange = function(_, value)
    config.spellDelay = value
    healerWindow.spellDelayText:setText("Spell Delay: " .. value .. " ms")
    end

    UI.Separator()


    -- pega os widgets corretamente (hierarquia OTUI)
    local itemsPanel  = healerWindow:getChildById('itemsPanel')
    local healthPanel = itemsPanel:getChildById('healthPanel')
    local manaPanel   = itemsPanel:getChildById('manaPanel')

    local healthItem = healthPanel:getChildById('healthItem')
    local manaItem   = manaPanel:getChildById('manaItem')

    -- Health item
    healthItem.onItemChange = function(widget)
    config.healthItemId = widget:getItemId()
    end
    healthItem:setItemId(config.healthItemId)

    -- Mana item
    manaItem.onItemChange = function(widget)
    config.manaItemId = widget:getItemId()
    end
    manaItem:setItemId(config.manaItemId)



end


ui.setup.onClick = function()
  healerWindow:show()
  healerWindow:raise()
  healerWindow:focus()
end

-- =========================
-- MACROS (ON / OFF)
-- =========================
local lastSpellCast = 0

macro(100, "Heal Spell", function()
  if config.healSpell == "" then return end
  if hppercent() >= config.hpPercent then return end

  if now - lastSpellCast < config.spellDelay then
    return
  end

  say(config.healSpell)
  lastSpellCast = now
end)

UI.Separator()

macro(200, "Health Item", function()
  if config.healthItemId == 0 then return end
  if hppercent() >= config.hpPercent then return end

  local pot = findItem(config.healthItemId)
  if pot then
    useHealingItem(pot)
  end
end)

UI.Separator()

macro(200, "Mana Item", function()
  if config.manaItemId == 0 then return end
  if manapercent() >= config.mpPercent then return end

  local pot = findItem(config.manaItemId)
  if pot then
    useHealingItem(pot)
  end
end)
